package ru.yandex.chemodan.app.notifier.notification;

import lombok.EqualsAndHashCode;
import lombok.ToString;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.notifier.dao.NotificationSettingsDaoImpl;
import ru.yandex.chemodan.app.notifier.metadata.MetadataWrapper;

/**
 * @author akirakozov
 */
@EqualsAndHashCode
@ToString
public class NewNotificationData {
    /**
     *  Actor, who initiate notification (user or Yandex.Disk)
     */
    public final NotificationActor actor;

    /**
     * User who must receive notification
     */
    public final DataApiUserId owner;
    /**
     * Key for aggregation of notifications
     */
    public final String groupKey;

    public final Option<String> subscriptionKey;

    public final NotificationType type;

    /**
     * New notification metadata:
     */
    public final MetadataWrapper metadata;

    public NewNotificationData(
            DataApiUserId owner,
            NotificationActor actor,
            Option<String> subscriptionKey,
            String groupKey,
            NotificationType type,
            MetadataWrapper metadata)
    {
        this.actor = actor;
        this.owner = owner;
        // TODO: move to better place makeResourceId
        this.subscriptionKey = subscriptionKey.map(NotificationSettingsDaoImpl::makeResourceId);
        this.groupKey = groupKey;
        this.type = type;
        this.metadata = metadata;
    }

}
