package ru.yandex.chemodan.app.notifier.notification;

import org.junit.Test;

import ru.yandex.chemodan.app.dataapi.api.user.DataApiPassportUserId;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiYaTeamUserId;
import ru.yandex.misc.test.Assert;

/**
 * @author akirakozov
 */
public class NotificationActorTest {

    @Test
    public void consFromSerialized() throws Exception {
        NotificationActor actor = NotificationActor.consFromSerialized("ya_disk");

        Assert.isFalse(actor.isUser());
        Assert.equals("ya_disk", actor.serialize());

        actor = NotificationActor.consFromSerialized("123");

        Assert.isTrue(actor.isUser());
        Assert.equals(new DataApiPassportUserId(123), actor.getUid());

        actor = NotificationActor.consFromSerialized("yt:1120000000000001");

        Assert.isTrue(actor.isUser());
        Assert.equals(new DataApiYaTeamUserId(1120000000000001L), actor.getUid());
    }

    @Test
    public void serialize() throws Exception {
        Assert.equals("ya_disk", NotificationActor.consFromStringName("ya_disk").serialize());
        Assert.equals("456", NotificationActor.consFromUid(new DataApiPassportUserId(456)).serialize());
        Assert.equals("yt:1120000000000001",
                NotificationActor.consFromUid(new DataApiYaTeamUserId(1120000000000001L)).serialize());
    }
}
