package ru.yandex.chemodan.app.notifier.notification;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.notifier.metadata.MetadataWrapper;

/**
 * @author akirakozov
 */
public class NotificationBlockUpdate {
    public Option<NotificationType> newRecordType;
    public Option<ListF<String>> counterUniques;
    public Option<Long> count;
    public Option<String> metadata;
    public Option<Instant> mtime;
    public Option<Boolean> isViewed;

    public NotificationBlockUpdate(
            ListF<String> counterUniques,
            long count, String metadata, Instant mtime, boolean isViewed)
    {
        this.newRecordType = Option.empty();
        this.count = Option.of(count);
        this.counterUniques = Option.of(counterUniques);
        this.metadata = Option.of(metadata);
        this.mtime = Option.of(mtime);
        this.isViewed = Option.of(isViewed);
    }

    public NotificationBlockUpdate(NotificationType newRecordType, ListF<String> counterUniques,
            Option<Long> count, String metadata, Instant mtime, boolean isViewed)
    {
        this.newRecordType = Option.of(newRecordType);
        this.counterUniques = Option.of(counterUniques);
        this.metadata = Option.of(metadata);
        this.mtime = Option.of(mtime);
        this.isViewed = Option.of(isViewed);
        this.count = count;
    }

    public NotificationBlockUpdate() {
        this.newRecordType = Option.empty();
        this.count = Option.empty();
        this.counterUniques = Option.empty();
        this.metadata = Option.empty();
        this.mtime = Option.empty();
        this.isViewed = Option.empty();
    }

    public NotificationBlockUpdate withNewRecordType(NotificationType newRecordType) {
        this.newRecordType = Option.of(newRecordType);
        return this;
    }

    public NotificationBlockUpdate withCounterUniques(ListF<String> counterUniques) {
        this.counterUniques = Option.of(counterUniques);
        return this;
    }

    public NotificationBlockUpdate withCount(long count) {
        this.count = Option.of(count);
        return this;
    }

    public NotificationBlockUpdate withMetadata(String metadata) {
        this.metadata = Option.of(metadata);
        return this;
    }

    public NotificationBlockUpdate withMetadata(MetadataWrapper metadata) {
        this.metadata = Option.of(metadata.toJsonString());
        return this;
    }

    public NotificationBlockUpdate withMtime(Instant mtime) {
        this.mtime = Option.of(mtime);
        return this;
    }

    public NotificationBlockUpdate unviewed() {
        this.isViewed = Option.of(Boolean.FALSE);
        return this;
    }

    public NotificationBlockUpdate viewed() {
        this.isViewed = Option.of(Boolean.TRUE);
        return this;
    }
}
