package ru.yandex.chemodan.app.notifier.notification;

import java.util.Objects;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.annotation.FillWithSomething;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultToString;

/**
 * @author akirakozov
 */
@BenderBindAllFields
public class NotificationGroup extends DefaultToString {

    public final Option<Integer> id;
    public final Option<Integer> service_id;

    public final String name;
    public final Option<String> description;
    private final Option<NotificationService> service;

    // used for having multiple notification groups under one setting
    public final Option<String> settingsGroupName;

    public NotificationGroup(String name, NotificationService service) {
        this(Option.empty(), Option.empty(), name, Option.empty(), Option.of(service), Option.empty());
    }

    public NotificationGroup(Integer id, Integer serviceId, String name, Option<String> description,
            Option<String> settingsGroupName)
    {
        this(Option.of(id), Option.of(serviceId), name, description, Option.empty(), settingsGroupName);
    }

    @FillWithSomething
    public NotificationGroup(Option<Integer> id, Integer serviceId, String name, Option<String> description,
            Option<String> settingsGroupName)
    {
        this(id, Option.of(serviceId), name, description, Option.empty(), settingsGroupName);
    }

    private NotificationGroup(Option<Integer> id, Option<Integer> service_id, String name, Option<String> description,
            Option<NotificationService> service, Option<String> settingsGroupName)
    {
        this.id = id;
        this.service_id = service_id;
        this.name = name;
        this.description = description;
        this.service = service;
        this.settingsGroupName = settingsGroupName;
    }

    public NotificationService getService() {
        return service.getOrThrow("Service is not defined");
    }

    public NotificationGroup withService(NotificationService service) {
        return new NotificationGroup(id, service_id, name, description, Option.of(service), settingsGroupName);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        NotificationGroup group = (NotificationGroup) o;
        return Objects.equals(name, group.name) &&
                Objects.equals(service, group.service);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, service);
    }

    public ServiceAndGroup getFullName() {
        return new ServiceAndGroup(getService().name, name);
    }

    public ServiceAndGroup getSettingsFullName() {
        return new ServiceAndGroup(getService().name, settingsGroupName.getOrElse(name));
    }
}
