package ru.yandex.chemodan.app.notifier.notification;

import java.util.Objects;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultToString;

/**
 * @author akirakozov
 */
@BenderBindAllFields
public class NotificationService extends DefaultToString {

    public final Option<Integer> id;
    public final String name;
    public final String tankerKeysetId;
    public final boolean isYaTeam;

    public NotificationService(int id, String name, String tankerKeysetId, boolean isYaTeam) {
        this(Option.of(id), name, tankerKeysetId, isYaTeam);
    }

    public NotificationService(Option<Integer> id, String name, String tankerKeysetId, boolean isYaTeam) {
        this.id = id;
        this.name = name;
        this.tankerKeysetId = tankerKeysetId;
        this.isYaTeam = isYaTeam;
    }

    public NotificationService withId(int id) {
        return new NotificationService(id, name, tankerKeysetId, isYaTeam);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        NotificationService service = (NotificationService) o;
        return Objects.equals(name, service.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name);
    }
}
