package ru.yandex.chemodan.app.notifier.notification;

import lombok.Data;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.support.RecordField;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

@Data
@BenderBindAllFields
public class NotificationServiceWidgetSettings {
    private static final String BLOCKS_POSTFIX = "_blocks";
    private static final String ICON_TYPE_SVG = "svg";
    private static final String MESSAGE_POSTFIX = "_message";
    private static final String SETTINGS_POSTFIX = "_common_settings";
    private static final String META = "meta";

    public final String blockCollection;
    public final String iconSrc;
    public final String iconType;
    public final String messageCollection;
    public final String settingsCollection;
    public final String unviewedCollection;
    public final String unviewedRecord;

    private interface Fields {
        RecordField<String> BLOCK_COLLECTION_FIELD = RecordField.string("block_collection");
        RecordField<String> ICON_SRC_FIELD = RecordField.string("icon_src");
        RecordField<String> ICON_TYPE_FIELD = RecordField.string("icon_type");
        RecordField<String> MESSAGE_COLLECTION_FIELD = RecordField.string("message_collection");
        RecordField<String> SETTINGS_COLLECTION_FIELD = RecordField.string("settings_collection");
        RecordField<String> UNVIEWED_COLLECTION_FIELD = RecordField.string("unviewed_collection");
        RecordField<String> UNVIEWED_RECORD_FIELD = RecordField.string("unviewed_record");
    }

    public static NotificationServiceWidgetSettings createDefault(String serviceName) {
        return new NotificationServiceWidgetSettings(serviceName + BLOCKS_POSTFIX, "", ICON_TYPE_SVG,
                serviceName + MESSAGE_POSTFIX, serviceName + SETTINGS_POSTFIX, META, serviceName);
    }

    public static NotificationServiceWidgetSettings fromDataRecord(DataRecord record) {
        return new NotificationServiceWidgetSettings(
                Fields.BLOCK_COLLECTION_FIELD.get(record),
                Fields.ICON_SRC_FIELD.get(record),
                Fields.ICON_TYPE_FIELD.get(record),
                Fields.MESSAGE_COLLECTION_FIELD.get(record),
                Fields.SETTINGS_COLLECTION_FIELD.get(record),
                Fields.UNVIEWED_COLLECTION_FIELD.get(record),
                Fields.UNVIEWED_RECORD_FIELD.get(record)
        );
    }

    public MapF<String, DataField> toData() {
        return Cf.toMap(Cf.list(
                Fields.BLOCK_COLLECTION_FIELD.toData(blockCollection),
                Fields.ICON_SRC_FIELD.toData(iconSrc),
                Fields.ICON_TYPE_FIELD.toData(iconType),
                Fields.MESSAGE_COLLECTION_FIELD.toData(messageCollection),
                Fields.SETTINGS_COLLECTION_FIELD.toData(settingsCollection),
                Fields.UNVIEWED_COLLECTION_FIELD.toData(unviewedCollection),
                Fields.UNVIEWED_RECORD_FIELD.toData(unviewedRecord)
        ));
    }
}
