package ru.yandex.chemodan.app.notifier.notification;

import lombok.Data;
import org.joda.time.Duration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.notifier.metadata.MetadataWrapper;
import ru.yandex.chemodan.app.notifier.tanker.TankerMessageKey;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author dbrylev
 */
@Data
@BenderBindAllFields
public class NotificationTemplate {
    private final String name;

    private final String type;
    private final String group;
    private final String service;

    private final String icon;

    private final TankerMessageKey messageKey;
    private final TankerMessageKey titleMessageKey;
    private final TankerMessageKey shortMessageKey;

    private final MetadataWrapper defaultMeta;
    private final Duration delay;

    private final Option<NotificationTemplateSelectionReason> templateSelectionReason;

    public NotificationTemplate withGroup(String group) {
        return new NotificationTemplate(
                name, type, group, service, icon, messageKey, titleMessageKey, shortMessageKey, defaultMeta, delay, templateSelectionReason);
    }

    public NotificationTemplate withReason(NotificationTemplateSelectionReason reason) {
        return new NotificationTemplate(
                name, type, group, service, icon, messageKey, titleMessageKey, shortMessageKey, defaultMeta, delay, Option.of(reason));
    }

    public ListF<NotificationTemplate> split() {
        ListF<String> msgKeys = Cf.x(messageKey.key.split(",")).map(String::trim);
        ListF<String> titles = Cf.x(titleMessageKey.key.split(",")).map(String::trim);
        ListF<String> shortKeys = Cf.x(shortMessageKey.key.split(",")).map(String::trim);
        Integer min = Cf.list(msgKeys.size(), titles.size(), shortKeys.size()).min();
        return Cf.range(0, min).map( ix ->
             new NotificationTemplate(name, type, group, service, icon,
                     new TankerMessageKey(messageKey.keysetId, msgKeys.get(ix)),
                     new TankerMessageKey(titleMessageKey.keysetId, titles.get(ix)),
                     new TankerMessageKey(shortMessageKey.keysetId, shortKeys.get(ix)),
                     defaultMeta, delay,
                     templateSelectionReason)
        );
    }

    public ServiceAndGroup getGroupName() {
        return new ServiceAndGroup(service, group);
    }

    public ServiceAndType getTypeName() {
        return new ServiceAndType(service, type);
    }
}
