package ru.yandex.chemodan.app.notifier.notification;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.notifier.notification.template.NotificationTemplateSelector;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author tolmalev
 */
public class NotificationTemplateResolver {

    private static final Logger logger = LoggerFactory.getLogger(NotificationTemplateResolver.class);

    private final ListF<NotificationTemplateSelector> selectors;

    private final DynamicProperty<Boolean> rtxEnabled = new DynamicProperty<>("disk-notifier-rtx-enabled", true);

    public NotificationTemplateResolver(ListF<NotificationTemplateSelector> selectors) {
        this.selectors = selectors;
    }

    public NotificationTemplate consTemplate(NotificationType type, DataApiUserId uid) {
        try {
            return findAppropriateSelector(type, rtxEnabled.get()).getOrThrow(IllegalStateException::new)
                    .selectTemplate(type, uid);
        } catch (RuntimeException e) {
            logger.info("Cannot choose the template", e);
            NotificationTemplate notificationTemplate = type.consMainTemplate();
            return notificationTemplate.withReason(NotificationTemplateSelectionReason.fallback(notificationTemplate, type));
        }
    }

    public Option<NotificationTemplateSelector> findAppropriateSelector(NotificationType type, boolean isRtxEnabled) {
        return selectors.find(selector -> selector.isAcceptableFor(type, isRtxEnabled));
    }
}
