package ru.yandex.chemodan.app.notifier.notification;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function3;
import ru.yandex.chemodan.app.notifier.NotificationTestUtils;
import ru.yandex.chemodan.app.notifier.metadata.MetadataWrapper;
import ru.yandex.chemodan.app.notifier.notification.template.NotificationTemplateSelector;
import ru.yandex.chemodan.app.notifier.notification.template.RandomNotificationTemplateSelector;
import ru.yandex.chemodan.app.notifier.notification.template.RtxNotificationTemplateSelector;
import ru.yandex.chemodan.app.notifier.notification.template.SingleVariantNotificationTemplateSelector;
import ru.yandex.misc.test.Assert;

/**
 * @author tolmalev
 */
public class NotificationTemplateResolverTest {

    private NotificationTemplateResolver resolver = new NotificationTemplateResolver(Cf.list(
            new RtxNotificationTemplateSelector(null, null),
            new SingleVariantNotificationTemplateSelector(),
            new RandomNotificationTemplateSelector()
    ));

    private Function3<String, Integer, Integer, NotificationVariant> consVariantCreator = (id, users, offset) -> new NotificationVariant(
            id, users, offset, Option.of("icon_" + id), Option.of("message_" + id),
            Option.of("title_" + id), Option.of("short_" + id),
            Option.of(new MetadataWrapper(Cf.map(id, Cf.map()))), Option.empty());

    @Test
    public void ttt() {
        Assert.equals("for_test_1", RtxNotificationTemplateSelector.parseVariantFromRtx("disk|unlim_autoupload|for_test_1"));
        Assert.equals("for_test_2", RtxNotificationTemplateSelector.parseVariantFromRtx("disk|unlim_autoupload|for_test_2"));
        Assert.equals("main", RtxNotificationTemplateSelector.parseVariantFromRtx("disk|unlim_autoupload|main"));
    }

    @Test
    public void testSelectorForOneVariant() {
        NotificationType type = NotificationTestUtils.NOTIFICATION_TYPE_FOR_TESTS
                .withAlternativeVariants(Cf.list());
        Option<NotificationTemplateSelector> selectorO = resolver.findAppropriateSelector(type, true);
        Assert.isTrue(selectorO.isPresent());
        Assert.isTrue(selectorO.filter(SingleVariantNotificationTemplateSelector.class::isInstance).isPresent());
    }

    @Test
    public void testSelectorForAlternativeVariantsWithRtx() {
        NotificationType type = NotificationTestUtils.NOTIFICATION_TYPE_FOR_TESTS
                .withAlternativeVariants(Cf.list(consVariantCreator.apply("1", 33, 0)));
        Option<NotificationTemplateSelector> selectorO = resolver.findAppropriateSelector(type, true);
        Assert.isTrue(selectorO.isPresent());
        Assert.isTrue(selectorO.filter(RtxNotificationTemplateSelector.class::isInstance).isPresent());
    }

    @Test
    public void testSelectorForAlternativeVariantsWithoutRtx() {
        NotificationType type = NotificationTestUtils.NOTIFICATION_TYPE_FOR_TESTS
                .withAlternativeVariants(Cf.list(consVariantCreator.apply("1", 33, 0)));
        Option<NotificationTemplateSelector> selectorO = resolver.findAppropriateSelector(type, false);
        Assert.isTrue(selectorO.isPresent());
        Assert.isTrue(selectorO.filter(RandomNotificationTemplateSelector.class::isInstance).isPresent());
    }
}
