package ru.yandex.chemodan.app.notifier.notification;

import NRtx.NProto.Api;
import lombok.Data;
import org.jetbrains.annotations.NotNull;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.notifier.notification.template.RtxNotificationTemplateSelector;
import ru.yandex.chemodan.app.notifier.rtx.RtxClient;
import ru.yandex.chemodan.http.YandexCloudRequestIdHolder;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.random.Random2;

/**
 * @author tolmalev
 */
@Data
@BenderBindAllFields
public class NotificationTemplateSelectionReason {
    public final Source reasonSource;
    public final MapF<String, String> metadata;

    public static NotificationTemplateSelectionReason rtx(
            RtxClient.UserFeatures userFeatures,
            Api.TApiResponse response)
    {
        // TODO:
        // platform
        return new NotificationTemplateSelectionReason(Source.RTX, Cf.map(
                "alternatives", Cf.x(response.getItemsList()).mkString(","),
                "rtx_reqid", response.getRtxReqid(),
                "reqid", genReqId(),
                "user_features", userFeatures.toJson()
        ));
    }

    public static NotificationTemplateSelectionReason singleVariant(NotificationTemplate template, NotificationType type) {
        return new NotificationTemplateSelectionReason(Source.SINGLE_VARIANT, defaultMetadata(template, type));
    }

    public static NotificationTemplateSelectionReason random(NotificationTemplate template, NotificationType type) {
        return new NotificationTemplateSelectionReason(Source.RANDOM, defaultMetadata(template, type));
    }

    public static NotificationTemplateSelectionReason uidSplit(NotificationTemplate template, NotificationType type) {
        return new NotificationTemplateSelectionReason(Source.UID_SPLIT, defaultMetadata(template, type));
    }

    public static NotificationTemplateSelectionReason fallback(NotificationTemplate template, NotificationType type) {
        return new NotificationTemplateSelectionReason(Source.FALLBACK, defaultMetadata(template, type));
    }

    public static NotificationTemplateSelectionReason fallbackUnresolved(NotificationTemplate template, NotificationType type) {
        return new NotificationTemplateSelectionReason(Source.FALLBACK_UNRESOLVED, defaultMetadata(template, type));
    }

    public static NotificationTemplateSelectionReason noPluralize(NotificationTemplate template, NotificationType type) {
        return new NotificationTemplateSelectionReason(Source.FALLBACK_UNRESOLVED, defaultMetadata(template, type));
    }

    private static MapF<String, String> defaultMetadata(NotificationTemplate template, NotificationType type) {
        ListF<String> allAlternatives = RtxNotificationTemplateSelector.formatVariantsForRtx(type);
        String selectedAlternative = RtxNotificationTemplateSelector.formatVariantForRtx(type, template);

        ListF<String> alternatives = Cf.list(selectedAlternative).plus(allAlternatives.filter(v -> !v.equals(selectedAlternative)));

        return Cf.map(
                "reqid", genReqId(),
                "alternatives", Cf.x(alternatives).mkString(",")
        );
    }

    @NotNull
    private static String genReqId() {
        return YandexCloudRequestIdHolder.getO().getOrElse("no-ycrid") + "_" + Random2.R.nextAlnum(10);
    }

    public enum Source {
        UID_SPLIT,
        SINGLE_VARIANT,
        FALLBACK,
        FALLBACK_UNRESOLVED,
        FALLBACK_NO_PLURALIZE,
        RANDOM,
        RTX
    }
}
