package ru.yandex.chemodan.app.notifier.notification;

import java.util.List;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.notifier.admin.dao.NotificationGroupJdbcDao;
import ru.yandex.chemodan.app.notifier.admin.dao.NotificationRecordTypeJdbcDao;
import ru.yandex.chemodan.app.notifier.admin.dao.NotificationServiceJdbcDao;
import ru.yandex.chemodan.app.notifier.notification.template.NotificationTemplateSelector;
import ru.yandex.chemodan.app.notifier.notification.template.RandomNotificationTemplateSelector;
import ru.yandex.chemodan.app.notifier.notification.template.RtxNotificationTemplateSelector;
import ru.yandex.chemodan.app.notifier.notification.template.SingleVariantNotificationTemplateSelector;
import ru.yandex.chemodan.app.notifier.rtx.RtxClient;
import ru.yandex.chemodan.app.notifier.rtx.RtxClientContextConfiguration;
import ru.yandex.chemodan.app.notifier.utils.BlackboxMultiplexed;
import ru.yandex.chemodan.app.notifier.utils.UserLanguageHelper;
import ru.yandex.chemodan.app.uaas.experiments.ExperimentsContextConfigutation;
import ru.yandex.chemodan.blackbox.ProdBlackboxContextConfiguration;
import ru.yandex.chemodan.blackbox.YtBlackboxContextConfiguration;
import ru.yandex.inside.passport.blackbox2.Blackbox2;
import ru.yandex.misc.io.file.File2;

/**
 * @author akirakozov
 */
@Configuration
@Import({
        ExperimentsContextConfigutation.class,
        RtxClientContextConfiguration.class,
        ProdBlackboxContextConfiguration.class,
        YtBlackboxContextConfiguration.class
})
public class NotificationTypeManagerContextConfiguration {

    @Bean
    public NotificationRecordTypeManager notificationRecordTypeManager(
            NotifierTypesLoader notifierTypesLoader,
            NotifierTypesFsCache notifierTypesFsCache)
    {
        return new NotificationRecordTypeManager(notifierTypesLoader, Option.of(notifierTypesFsCache));
    }

    @Bean
    public NotificationTemplateSelector randomNotificationTemplateSelector() {
        return new RandomNotificationTemplateSelector();
    }

    @Bean
    public NotificationTemplateSelector rtxNotificationTemplateSelector(RtxClient rtxClient,
            UserLanguageHelper userLanguageHelper)
    {
        return new RtxNotificationTemplateSelector(rtxClient, userLanguageHelper);
    }

    @Bean
    public NotificationTemplateSelector singleVariantNotificationTemplateSelector() {
        return new SingleVariantNotificationTemplateSelector();
    }

    @Bean
    public NotificationTemplateResolver notificationTemplateResolver(List<NotificationTemplateSelector> selectors) {
        return new NotificationTemplateResolver(Cf.x(selectors));
    }

    @Bean
    public BlackboxMultiplexed blackboxMultiplexed(
            @Qualifier("blackbox2")
            Blackbox2 prodBlackbox,
            @Qualifier("ytBlackbox2")
            Blackbox2 ytBlackbox)
    {
        return new BlackboxMultiplexed(prodBlackbox, ytBlackbox);
    }

    @Bean
    public UserLanguageHelper userLanguageHelper(BlackboxMultiplexed blackbox) {
        return new UserLanguageHelper(blackbox);
    }

    @Bean
    public NotifierTypesLoader notifierTypesLoader(
            NotificationRecordTypeJdbcDao typesDao, NotificationGroupJdbcDao groupDao,
            NotificationServiceJdbcDao serviceDao)
    {
        return new NotifierTypesPGaaSLoader(typesDao, groupDao, serviceDao);
    }

    @Bean
    public NotifierTypesFsCache notifierTypesFsCache(
            @Value("${notifier.types.cache.file}") String cacheFile)
    {
        return new NotifierTypesFsCache(new File2(cacheFile));
    }
}
