package ru.yandex.chemodan.app.notifier.notification;

import org.joda.time.Duration;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.notifier.admin.NotifierTypesData;
import ru.yandex.chemodan.app.notifier.config.CounterConfiguration;
import ru.yandex.chemodan.app.notifier.metadata.MetadataWrapper;
import ru.yandex.chemodan.app.notifier.notification.disk.DiskServices;
import ru.yandex.misc.test.Assert;

import static org.mockito.Mockito.when;

/**
 * @author akirakozov
 */
public class NotificationTypeManagerTest {

    @Mock
    private NotifierTypesLoader typesLoader;

    private NotificationRecordTypeManager typeManager;

    private static final String SERVICE = DiskServices.DISK;

    @Before
    public void init() {
        MockitoAnnotations.initMocks(this);

        typeManager = new NotificationRecordTypeManager(typesLoader, Option.empty());
    }

    @Test
    public void refreshCashedTypesData() {
        when(typesLoader.loadFilledRecordTypes()).thenReturn(createTestData());

        // check, that overrides from typesLoader works properly
        typeManager.refreshCashedTypesData();

        Assert.some(1, typeManager.resolveNotificationGroup("likes", SERVICE).id);
        NotificationType type = typeManager.resolveRecordType("comment_like", SERVICE);
        Assert.some(2, type.id);
        Assert.some(1, type.getGroup().id);
        Assert.some(3, type.getService().id);

        NotificationGroup group = typeManager.getNotificationGroups(SERVICE)
                .filter(g -> g.name.equals("likes")).first();
        Assert.some(1, group.id);
    }

    private NotifierTypesData createTestData() {
        // group id - 1, type id - 2, service id - 3
        NotificationService service = new NotificationService(3, SERVICE, "keyset-id", false);
        NotificationGroup group =
                new NotificationGroup(1, 3, "likes", Option.empty(), Option.empty()).withService(service);
        NotificationType type = new NotificationType(
                    2, 1, "comment_like", NotificationIcon.DEFAULT, "", "", "", Option.empty(),
                    CounterConfiguration.NONE, MetadataWrapper.createEmpty(), Duration.ZERO, Cf.list()
        ).withGroup(group);

        return new NotifierTypesData(Cf.list(type), Cf.list(group));
    }
}
