package ru.yandex.chemodan.app.notifier.notification;

import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.notifier.admin.dao.test.NotificationEmbeddedPgConfiguration;
import ru.yandex.chemodan.boot.ChemodanTestBaseContextConfiguration;
import ru.yandex.chemodan.test.BazingaEmbeddedPgConfiguration;
import ru.yandex.chemodan.zk.configuration.ImportZkEmbeddedConfiguration;
import ru.yandex.commune.alive2.location.TestLocationResolverConfiguration;
import ru.yandex.misc.version.SimpleAppName;

/**
 * @author dbrylev
 */
@Configuration
@ImportZkEmbeddedConfiguration
@Import({
        BazingaEmbeddedPgConfiguration.class,
        NotificationEmbeddedPgConfiguration.class,
        NotificationTypeManagerContextConfiguration.class,
        TestLocationResolverConfiguration.class,
})
public class NotificationTypeManagerTestContextConfiguration extends ChemodanTestBaseContextConfiguration {

    @Override
    protected SimpleAppName appName() {
        return new SimpleAppName("disk", "notifier");
    }
}
