package ru.yandex.chemodan.app.notifier.notification;

import lombok.Data;
import org.joda.time.Duration;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.notifier.metadata.MetadataWrapper;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author dbrylev
 */
@Data
@BenderBindAllFields
public class NotificationVariant {

    private final String name;

    private final float usersPercent;
    private final float offsetPercent;

    private final Option<String> icon;
    private final Option<String> messageKey;
    private final Option<String> titleMessageKey;
    private final Option<String> shortMessageKey;
    private final Option<MetadataWrapper> defaultMeta;
    private final Option<Duration> delay;


    public static NotificationVariant consMain() {
        return new NotificationVariant(
                "main", 0, 100, Option.empty(), Option.empty(), Option.empty(), Option.empty(), Option.empty(), Option.empty());
    }

    public boolean matches(DataApiUserId uid) {
        float value = uid.discriminant() % 10000 / 100f;
        return value >= offsetPercent && value < offsetPercent + usersPercent;
    }
}
