package ru.yandex.chemodan.app.notifier.notification;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function3;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.notifier.NotificationTestUtils;
import ru.yandex.chemodan.app.notifier.metadata.MetadataWrapper;
import ru.yandex.chemodan.app.notifier.notification.template.NotificationTemplateSelector;
import ru.yandex.chemodan.app.notifier.notification.template.UidSplitNotificationTemplateSelector;
import ru.yandex.misc.test.Assert;

/**
 * @author dbrylev
 */
public class NotificationVariantsTest {

    private NotificationTemplateSelector templateSelector = new UidSplitNotificationTemplateSelector();

    @Test
    public void chooseForUser() {
        Function3<String, Integer, Integer, NotificationVariant> cons = (id, users, offset) -> new NotificationVariant(
                id, users, offset, Option.of("icon_" + id), Option.of("message_" + id),
                Option.of("title_" + id), Option.of("short_" + id),
                Option.of(new MetadataWrapper(Cf.map(id, Cf.map()))), Option.empty());

        NotificationVariant variant1 = cons.apply("1", 33, 0);
        NotificationVariant variant2 = cons.apply("2", 33, 67);

        NotificationType type = NotificationTestUtils.NOTIFICATION_TYPE_FOR_TESTS
                .withAlternativeVariants(Cf.list(variant1, variant2));

        NotificationTemplate template1 = templateSelector.selectTemplate(type, DataApiUserId.parse("1"));

        Assert.equals(template1.getName(), variant1.getName());

        Assert.some(template1.getIcon(), variant1.getIcon());
        Assert.some(template1.getMessageKey().key, variant1.getMessageKey());

        NotificationTemplate template2 = templateSelector.selectTemplate(type, DataApiUserId.parse("9999"));

        Assert.some(template2.getTitleMessageKey().key, variant2.getTitleMessageKey());
        Assert.some(template2.getShortMessageKey().key, variant2.getShortMessageKey());

        Assert.some(template2.getDefaultMeta(), variant2.getDefaultMeta());

        NotificationTemplate main = templateSelector.selectTemplate(type, DataApiUserId.parse("5555"));

        Assert.equals("main", main.getName());
        Assert.equals(type.defaultMetadata, main.getDefaultMeta());
    }
}
