package ru.yandex.chemodan.app.notifier.notification;

import ru.yandex.chemodan.app.notifier.admin.NotifierTypesData;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author akirakozov
 */
public class NotifierTypesFsCache implements NotifierTypesLoader {
    private static final Logger logger = LoggerFactory.getLogger(NotifierTypesFsCache.class);

    private final File2 cached;

    public NotifierTypesFsCache(File2 cached) {
        this.cached = cached;
    }

    @Override
    public NotifierTypesData loadFilledRecordTypes() {
        return loadTypesInternal();
    }

    private synchronized NotifierTypesData loadTypesInternal() {
        return NotifierTypesData.fromJson(cached.readText());
    }

    public synchronized void storeFilledRecordTypes(NotifierTypesData data) {
        try {
            cached.write(data.toJson());
        } catch (Exception e) {
            logger.warn("Couldn't write notifier types info to cache", e);
        }
    }
}
