package ru.yandex.chemodan.app.notifier.notification;

import org.joda.time.Duration;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.notifier.admin.dao.NotificationGroupJdbcDao;
import ru.yandex.chemodan.app.notifier.admin.dao.NotificationRecordTypeJdbcDao;
import ru.yandex.chemodan.app.notifier.admin.dao.NotificationServiceJdbcDao;
import ru.yandex.chemodan.app.notifier.config.CounterConfiguration;
import ru.yandex.chemodan.app.notifier.metadata.MetadataWrapper;
import ru.yandex.misc.test.Assert;

import static org.mockito.Mockito.when;

/**
 * @author akirakozov
 */
public class NotifierTypesLoaderTest {
    private NotifierTypesLoader loader;

    @Mock
    private NotificationRecordTypeJdbcDao typeJdbcDao;
    @Mock
    private NotificationGroupJdbcDao groupJdbcDao;
    @Mock
    private NotificationServiceJdbcDao serviceJdbcDao;


    @Before
    public void setup() {
        MockitoAnnotations.initMocks(this);

        loader = new NotifierTypesPGaaSLoader(typeJdbcDao, groupJdbcDao, serviceJdbcDao);
    }

    @Test
    public void loadRecordTypesData() {
        NotificationService service = new NotificationService(1, "service", "tanker_keyset", false);

        ListF<NotificationType> resultTypes = Cf.range(1, 4).map(i -> createType(i, 1))
                .plus(Cf.range(4, 6).map(i -> createType(i, 2)));
        when(typeJdbcDao.findAll()).thenReturn(resultTypes);
        when(groupJdbcDao.findAll()).thenReturn(Cf.range(1, 3).map(i -> createGroup(i)));
        when(serviceJdbcDao.findAll()).thenReturn(Cf.list(service));

        ListF<NotificationType> types = loader.loadFilledRecordTypes().types;

        Assert.hasSize(5, types);
        Assert.hasSize(3, types.filter(t -> t.getGroup().id.isSome(1)));
        Assert.hasSize(2, types.filter(t -> t.getGroup().id.isSome(2)));
        for (NotificationType type : types) {
            Assert.equals(service, type.getGroup().getService());
        }
    }

    private NotificationType createType(int id, int groupId) {
        return new NotificationType(
                id, groupId, "name_" + id, NotificationIcon.DEFAULT,
                "msg_" + id, "msg_title_" + id, "msg_short_id", Option.empty(),
                CounterConfiguration.NONE, MetadataWrapper.createEmpty(), Duration.ZERO, Cf.list());
    }

    private NotificationGroup createGroup(int id) {
        return new NotificationGroup(id, 1, "group_name_" + id, Option.empty(), Option.empty());
    }

}
