package ru.yandex.chemodan.app.notifier.notification;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.notifier.admin.NotifierTypesData;
import ru.yandex.chemodan.app.notifier.admin.dao.NotificationGroupJdbcDao;
import ru.yandex.chemodan.app.notifier.admin.dao.NotificationRecordTypeJdbcDao;
import ru.yandex.chemodan.app.notifier.admin.dao.NotificationServiceJdbcDao;

/**
 * @author akirakozov
 */
public class NotifierTypesPGaaSLoader implements NotifierTypesLoader {
    private final NotificationRecordTypeJdbcDao typesDao;
    private final NotificationGroupJdbcDao groupDao;
    private final NotificationServiceJdbcDao serviceDao;


    public NotifierTypesPGaaSLoader(
            NotificationRecordTypeJdbcDao typesDao, NotificationGroupJdbcDao groupDao,
            NotificationServiceJdbcDao serviceDao)
    {
        this.typesDao = typesDao;
        this.groupDao = groupDao;
        this.serviceDao = serviceDao;
    }

    @Override
    public NotifierTypesData loadFilledRecordTypes() {
        MapF<Integer, NotificationService> services = serviceDao.findAll().toMapMappingToKey(s -> s.id.get());
        ListF<NotificationGroup> groups = groupDao.findAll()
                .map(g -> g.withService(services.getTs(g.service_id.get())));
        MapF<Integer, NotificationGroup> groupsMap = groups.toMapMappingToKey(g -> g.id.get());
        ListF<NotificationType> types = typesDao
                .findAll()
                .map(t -> t.withGroup(groupsMap.getTs(t.groupId.get())));

        return new NotifierTypesData(types, groups);
    }
}
