package ru.yandex.chemodan.app.notifier.notification.template;

import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.notifier.notification.NotificationTemplate;
import ru.yandex.chemodan.app.notifier.notification.NotificationTemplateSelectionReason;
import ru.yandex.chemodan.app.notifier.notification.NotificationType;
import ru.yandex.misc.random.Random2;

public class RandomNotificationTemplateSelector implements NotificationTemplateSelector {

    @Override
    public NotificationTemplate selectTemplate(NotificationType notificationType, DataApiUserId userId) {
        NotificationTemplate template = notificationType.alternativeVariants.isEmpty()
                ? notificationType.consMainTemplate()
                : notificationType.consTemplate(Random2.R.randomElement(notificationType.alternativeVariants));
        return template.withReason(NotificationTemplateSelectionReason.random(template, notificationType));
    }

    @Override
    public boolean isAcceptableFor(NotificationType notificationType, boolean rtxEnabled) {
        return !rtxEnabled && notificationType.alternativeVariants.isNotEmpty();
    }
}
