package ru.yandex.chemodan.app.notifier.notification.template;

import NRtx.NProto.Api;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.notifier.notification.NotificationTemplate;
import ru.yandex.chemodan.app.notifier.notification.NotificationTemplateSelectionReason;
import ru.yandex.chemodan.app.notifier.notification.NotificationType;
import ru.yandex.chemodan.app.notifier.rtx.RtxClient;
import ru.yandex.chemodan.app.notifier.utils.UserLanguageHelper;

/**
 * added for compatibility. The RTX-service is on planning to be disabled
 */
@Deprecated
public class RtxNotificationTemplateSelector implements NotificationTemplateSelector {

    public static ListF<String> formatVariantsForRtx(NotificationType type) {
        return type.getAllVariants().map(type::consTemplate).map(v -> formatVariantForRtx(type, v));
    }

    public static String parseVariantFromRtx(String firstVariant) {
        return firstVariant.split("\\|")[2];
    }

    public static String formatVariantForRtx(NotificationType type, NotificationTemplate template) {
        String prefix = type.getService().name + "|" + type.name + "|";
        return prefix + template.getName();
    }

    private final RtxClient rtxClient;

    private final UserLanguageHelper userLanguageHelper;

    public RtxNotificationTemplateSelector(RtxClient rtxClient, UserLanguageHelper userLanguageHelper) {
        this.rtxClient = rtxClient;
        this.userLanguageHelper = userLanguageHelper;
    }

    @Override
    public NotificationTemplate selectTemplate(NotificationType notificationType, DataApiUserId userId) {
        ListF<String> variants = formatVariantsForRtx(notificationType);

        String locale = userLanguageHelper.getUserLanguageOrDefault(userId).value();

        RtxClient.UserFeatures userFeatures = new RtxClient.UserFeatures(locale);
        Api.TApiResponse response = rtxClient.request(userId.toPassportUid(), userFeatures, variants);
        String firstVariant = response.getItems(0);
        String variantName = parseVariantFromRtx(firstVariant);

        return notificationType.consTemplate(variantName)
                .withReason(NotificationTemplateSelectionReason.rtx(userFeatures, response));
    }

    @Override
    public boolean isAcceptableFor(NotificationType notificationType, boolean rtxEnabled) {
        return rtxEnabled && notificationType.alternativeVariants.isNotEmpty();
    }
}
