package ru.yandex.chemodan.app.notifier.notification.template;

import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.notifier.notification.NotificationTemplate;
import ru.yandex.chemodan.app.notifier.notification.NotificationTemplateSelectionReason;
import ru.yandex.chemodan.app.notifier.notification.NotificationType;

public class SingleVariantNotificationTemplateSelector implements NotificationTemplateSelector {

    @Override
    public NotificationTemplate selectTemplate(NotificationType notificationType, DataApiUserId userId) {
        NotificationTemplate template = notificationType.consMainTemplate();
        return template.withReason(NotificationTemplateSelectionReason.singleVariant(template, notificationType));
    }

    @Override
    public boolean isAcceptableFor(NotificationType notificationType, boolean rtxEnabled) {
        return notificationType.alternativeVariants.isEmpty();
    }
}
