package ru.yandex.chemodan.app.notifier.notification.template;

import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.notifier.notification.NotificationTemplate;
import ru.yandex.chemodan.app.notifier.notification.NotificationTemplateSelectionReason;
import ru.yandex.chemodan.app.notifier.notification.NotificationType;
import ru.yandex.chemodan.app.notifier.notification.NotificationVariant;

public class UidSplitNotificationTemplateSelector implements NotificationTemplateSelector {

    @Override
    public NotificationTemplate selectTemplate(NotificationType notificationType, DataApiUserId userId) {
        NotificationTemplate template =
                notificationType.consTemplate(notificationType.alternativeVariants.find(v -> v.matches(userId))
                        .getOrElse(NotificationVariant::consMain));
        return template.withReason(NotificationTemplateSelectionReason.uidSplit(template, notificationType));
    }

    @Override
    public boolean isAcceptableFor(NotificationType notificationType, boolean rtxEnabled) {
        return false;
    }
}
