package ru.yandex.chemodan.app.notifier.notification.toggling;

import ru.yandex.bolts.collection.SetF;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author bursy
 */
@BenderBindAllFields
public class NotificationToggleSettings {
    public final String serviceName;
    public final String notificationTypeName;

    public NotificationToggleType type;
    public SetF<String> enabledUids;

    public NotificationToggleSettings(String serviceName, String notificationTypeName, NotificationToggleType type,
            SetF<String> enabledUids)
    {
        this.serviceName = serviceName;
        this.notificationTypeName = notificationTypeName;
        this.type = type;
        this.enabledUids = enabledUids;
    }

    @Override
    public String toString() {
        return String.format("Service: %s, "
                        + "Notification type: %s, "
                        + "Toggle type: %s, "
                        + "Enabled uids: %s",
                serviceName,
                notificationTypeName,
                type,
                enabledUids
        );

    }
}
