package ru.yandex.chemodan.app.notifier.promo;

import org.joda.time.Instant;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiPassportUserId;
import ru.yandex.chemodan.app.notifier.admin.dao.test.ActivateNotificationEmbeddedPg;
import ru.yandex.chemodan.app.notifier.notification.NotificationRecordTypeManager;
import ru.yandex.chemodan.app.notifier.notification.NotificationTypeManagerTestContextConfiguration;
import ru.yandex.chemodan.app.notifier.push.NotificationPushManager;
import ru.yandex.chemodan.app.notifier.worker.task.SendPushTask;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.thread.ThreadUtils;

import static org.mockito.Matchers.any;
import static org.mockito.Matchers.eq;
import static org.mockito.Mockito.atLeast;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;

/**
 * @author akirakozov
 */
@ActivateNotificationEmbeddedPg
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes = NotificationTypeManagerTestContextConfiguration.class)
@TestExecutionListeners(value = DependencyInjectionTestExecutionListener.class)
public class PromoActionManagerTest {

    @Autowired
    private NotificationRecordTypeManager notificationRecordTypeManager;

    @Mock
    private NotificationPushManager pushManager;

    private PromoActionManager promoActionManager;

    @Before
    public void init() {
        MockitoAnnotations.initMocks(this);

        promoActionManager = new PromoActionManager(
                pushManager, notificationRecordTypeManager, null);
    }

    @Test
    public void sendPushNotificationForActionUnlimPhotostream() {
        DataApiPassportUserId uid = new DataApiPassportUserId(123);

        promoActionManager.sendPromo(uid, Option.empty(), Option.empty());
        verify(pushManager, times(2)).pushNotificationWithDelay(eq(uid), any(), any());

        promoActionManager.sendPromo(uid, Option.of("ios"), Option.empty());
        verify(pushManager, times(3)).pushNotificationWithDelay(eq(uid), any(), any());

        promoActionManager.sendPromo(uid, Option.of("android"), Option.empty());
        verify(pushManager, times(4)).pushNotificationWithDelay(eq(uid), any(), any());

        promoActionManager.sendPromo(uid, Option.of("unknown"), Option.empty());
        verify(pushManager, times(4)).pushNotificationWithDelay(eq(uid), any(), any());
    }

    @Test
    @Ignore //fix for CI: java.lang.IllegalArgumentException: URI is not hierarchical
    public void schedulePromoActionUnlimPhotostreamTasksFromFile() throws Exception {
        BazingaTaskManager bazingaTaskManager = mock(BazingaTaskManager.class);
        PromoActionManager promoActionManager = new PromoActionManager(
                mock(NotificationPushManager.class),
                mock(NotificationRecordTypeManager.class),
                bazingaTaskManager);
        java.net.URL url = PromoActionManagerTest.class.getResource("ids.text");
        promoActionManager.schedulePromoActionTasksFromFile(new File2(url.toURI()), Instant.now(), 1);
        ThreadUtils.sleep(1000);
        verify(bazingaTaskManager, atLeast(14)).schedule(
                any(SendPushTask.class),
                any(Instant.class));
    }

}
