package ru.yandex.chemodan.app.notifier.push;

import java.net.URI;

import javax.annotation.PostConstruct;

import org.apache.http.client.HttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;
import ru.yandex.chemodan.app.dataapi.core.xiva.XivaContextConfiguration;
import ru.yandex.chemodan.app.notifier.locale.LocaleManager;
import ru.yandex.chemodan.app.notifier.push.body.XivaPushSpecificParamsCreator;
import ru.yandex.chemodan.app.notifier.push.filter.NotificationPushFilterManager;
import ru.yandex.chemodan.app.notifier.settings.NotificationsGlobalSettingsManager;
import ru.yandex.chemodan.app.notifier.settings.NotificationsSettingsManager;
import ru.yandex.chemodan.app.notifier.utils.UserLanguageHelper;
import ru.yandex.chemodan.ratelimiter.RateLimiterClient;
import ru.yandex.chemodan.ratelimiter.RateLimiterHttpClientContextConfiguration;
import ru.yandex.chemodan.xiva.XivaSingleTokenClient;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.commune.dynproperties.DynamicPropertyManager;

/**
 * @author akirakozov
 */
@Configuration
@Import({
        XivaContextConfiguration.class,
        RateLimiterHttpClientContextConfiguration.class,
})
public class NotificationPushClientContext {
    @Autowired
    private XivaSingleTokenClient xivaClient;

    @Bean
    public RateLimiterClient notifierRateLimiter(
            @Qualifier("rateLimiter") HttpClient client,
            @Value("${ratelimiter.uri}") URI uri,
            @Value("${notifier.ratelimiter.group}") String group)
    {
        return new RateLimiterClient(client, uri, group, false);
    }

    @Bean
    public NotificationPushFilterManager notificationPushFilterManager(
            DataApiManager dataApiManager)
    {
        return new NotificationPushFilterManager(xivaClient, dataApiManager);
    }

    @Bean
    public NotificationPushManager notificationPushManager(
            LocaleManager localeManager,
            UserLanguageHelper userLanguageHelper,
            PushSettingsManager pushSettingsManager,
            BazingaTaskManager bazingaTaskManager,
            NotificationPushFilterManager pushFilterManager,
            @Value("${notifier.lenta.base.url}") String lentaBaseUrl,
            @Value("${notifier.push.max-title-length}") int maxTitleLength)
    {
        return new NotificationPushManager(
                xivaClient, userLanguageHelper,
                localeManager, pushSettingsManager,
                bazingaTaskManager, pushFilterManager,
                lentaBaseUrl, maxTitleLength);
    }

    @Bean
    public PushSettingsManager pushSettingsManager(
            NotificationsSettingsManager settingsManager,
            NotificationsGlobalSettingsManager globalSettingsManager,
            RateLimiterClient notifierRateLimiter)
    {
        return new PushSettingsManager(settingsManager, globalSettingsManager, notifierRateLimiter);
    }

    @Autowired
    private DynamicPropertyManager dynamicPropertyManager;

    @PostConstruct
    public void init() {
        dynamicPropertyManager.addStaticFields(XivaPushSpecificParamsCreator.class);
    }
}
