package ru.yandex.chemodan.app.notifier.push;

import lombok.AllArgsConstructor;
import lombok.Data;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.notifier.notification.NotificationActor;
import ru.yandex.chemodan.app.notifier.notification.NotificationRecord;
import ru.yandex.chemodan.app.notifier.notification.NotificationTemplate;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author akirakozov
 */
@Data
@AllArgsConstructor
@BenderBindAllFields
public class NotificationPushInfo {
    public final NotificationTemplate template;
    public final NotificationActor actor;
    public final Instant ctime;
    public final Option<String> subscriptionKey;
    public final Option<Long> count;
    public final ListF<String> platformFilter;

    public NotificationPushInfo(NotificationTemplate template, NotificationActor actor, Instant ctime, Option<String> subscriptionKey,
                                Option<Long> count)
    {
        this.template = template;
        this.actor = actor;
        this.ctime = ctime;
        this.subscriptionKey = subscriptionKey;
        this.count = count;
        this.platformFilter = Cf.list();
    }

    public NotificationPushInfo(
            NotificationTemplate template,
            NotificationActor actor,
            Instant ctime,
            Option<String> subscriptionKey)
    {
        this(template, actor, ctime, subscriptionKey, Option.empty());
    }

    public NotificationPushInfo(NotificationTemplate template, NotificationActor actor, Instant ctime) {
        this(template, actor, ctime, Option.empty());
    }

    public static NotificationPushInfo fromRecord(NotificationTemplate template, NotificationRecord record) {
        return new NotificationPushInfo(template, record.actor, record.ctime, record.subscriptionKey);
    }

    public NotificationPushInfo withPlatformFilter(ListF<String> pushPlatforms) {
        return new NotificationPushInfo(template, actor, ctime, subscriptionKey, count, pushPlatforms);
    }
}
