package ru.yandex.chemodan.app.notifier.push;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.notifier.inflector.Gender;
import ru.yandex.chemodan.app.notifier.inflector.InflectorClient;
import ru.yandex.chemodan.app.notifier.inflector.InflectorResponse;
import ru.yandex.chemodan.app.notifier.locale.LocaleManager;
import ru.yandex.chemodan.app.notifier.metadata.NotifierLanguage;
import ru.yandex.chemodan.app.notifier.tanker.TankerManager;
import ru.yandex.chemodan.app.notifier.tanker.TankerManagerTestConfiguration;

/**
 * @author buberman
 */
@Configuration
@Import(TankerManagerTestConfiguration.class)
public class NotifierPushManagerTestContext {

    @Bean
    LocaleManager localeManager(TankerManager tankerManager, InflectorClient inflectorClient) {
        return new LocaleManager(tankerManager, inflectorClient);
    }

    @Bean
    public InflectorClient inflectorClient() {
        return new InflectorClient() {
            @Override
            public InflectorResponse inflectFio(String text, NotifierLanguage lang, Option<Gender> gender) {
                InflectorResponse inflectorResponse = new InflectorResponse();
                inflectorResponse.forms = Cf.map("дат", text + "у" );
                return inflectorResponse;
            }

            @Override
            public InflectorResponse inflectGeo(String text, NotifierLanguage lang) {
                InflectorResponse inflectorResponse = new InflectorResponse();
                inflectorResponse.forms = Cf.map("вин", text + "у" );
                return inflectorResponse;
            }
        };
    }
}
