package ru.yandex.chemodan.app.notifier.push;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.notifier.metadata.MetadataWrapper;
import ru.yandex.chemodan.app.notifier.notification.LocalizedMessage;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author akirakozov
 */
public class TextMessageGenerator {
    public static final Pattern ENTITY_PATTERN = Pattern.compile("%\\{([a-zA-Z_).:]*)\\}");

    public String generateSimpleTextMessage(LocalizedMessage message, MetadataWrapper meta,
            Option<Integer> maxTitleLength)
    {
        Matcher matcher = ENTITY_PATTERN.matcher(message.message);

        StringBuilder sb = new StringBuilder();

        int pos = 0;
        while (matcher.find()) {
            sb.append(message.message, pos, matcher.start());
            pos = matcher.end();

            String entityName = matcher.group(1);
            String replacement = message.meta.getEntityField(entityName, "text")
                    .orElse(meta.getEntityField(entityName, "text"))
                    .getOrElse("");

            if (matcher.start() == 0 || StringUtils.strip(sb.toString()).endsWith(".")) {
                replacement = StringUtils.capitalize(replacement);
            }

            sb.append(replacement);
        }
        sb.append(message.message.substring(pos));

        if (maxTitleLength.isPresent()) {
            return StringUtils.abbreviate(sb.toString(), maxTitleLength.get());
        }
        return sb.toString();
    }
}
