package ru.yandex.chemodan.app.notifier.push.body;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.chemodan.app.notifier.push.NotificationPushInfo;
import ru.yandex.chemodan.xiva.XivaPushBody;
import ru.yandex.chemodan.xiva.XivaPushBodyRepack;
import ru.yandex.chemodan.xiva.XivaPushService;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.MarshallerContext;

/**
 * @author tolmalev
 * @author vpronto
 */
public class IosAlertPushBody implements XivaPushBody, XivaBodyWithTitleAndText {
    private final NotificationPushInfo info;
    private final Tuple2<String, String> mobilePushMessageTexts;
    private final String notificationEvents;
    private final Option<String> link;

    public IosAlertPushBody(NotificationPushInfo info, Tuple2<String, String> mobilePushMessageTexts,
            String notificationEvents, Option<String> link)
    {
        this.info = info;
        this.mobilePushMessageTexts = mobilePushMessageTexts;
        this.notificationEvents = notificationEvents;
        this.link = link;
    }

    @Override
    public void writePushBodyAsJson(BenderJsonWriter json, MarshallerContext context) {
        json.writeObjectStart();
        json.writeFieldName("group_type");
        json.writeString(info.template.getGroup());

        json.writeFieldName("t");
        json.writeString(notificationEvents);

        json.writeFieldName("action_type");
        json.writeString(info.template.getType());

        json.writeFieldName("template");
        json.writeString(info.template.getName());

        link.ifPresent(l -> {
            json.writeFieldName("link");
            json.writeString(l);

            json.writeFieldName("title");
            json.writeString(mobilePushMessageTexts._1);

            json.writeFieldName("text");
            json.writeString(mobilePushMessageTexts._2);
        });

        json.writeObjectEnd();
    }

    @Override
    public XivaPushBodyRepack getRepack() {
        return new XivaPushBodyRepack()
                .withServiceRepack(XivaPushService.APNS,
                        repack -> repack.addStandardField("aps", Cf.map(
                                "alert", consAlertBody()
                        ))
                )
                .withServiceRepack(XivaPushService.GCM)
                .includeAllPayloadFieldsToAllServices();
    }

    private MapF<String, String> consAlertBody() {
        return Cf.<String, String>linkedHashMap()
                .plus1("title", mobilePushMessageTexts._1)
                .plus1("body", mobilePushMessageTexts._2);
    }

    @Override
    public Tuple2<String, String> getTitleAndText() {
        return mobilePushMessageTexts;
    }
}
