package ru.yandex.chemodan.app.notifier.push.body;

import org.jetbrains.annotations.NotNull;
import org.joda.time.Instant;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.chemodan.app.notifier.admin.dao.test.ActivateNotificationEmbeddedPg;
import ru.yandex.chemodan.app.notifier.notification.NotificationActor;
import ru.yandex.chemodan.app.notifier.notification.NotificationRecordTypeManager;
import ru.yandex.chemodan.app.notifier.notification.NotificationTypeManagerTestContextConfiguration;
import ru.yandex.chemodan.app.notifier.notification.disk.DiskNotifications;
import ru.yandex.chemodan.app.notifier.push.NotificationEvents;
import ru.yandex.chemodan.app.notifier.push.NotificationPushInfo;
import ru.yandex.chemodan.app.notifier.settings.GlobalSubscriptionChannel;
import ru.yandex.chemodan.util.JsonAssert;
import ru.yandex.chemodan.xiva.XivaEvent;
import ru.yandex.chemodan.xiva.XivaEventRecipient;

/**
 * @author akirakozov
 */
@ActivateNotificationEmbeddedPg
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes = NotificationTypeManagerTestContextConfiguration.class)
@TestExecutionListeners(value = DependencyInjectionTestExecutionListener.class)
public class IosAlertPushBodyTest {

    @Autowired
    private NotificationRecordTypeManager typeManager;

    @Test
    public void genIosAlertBody() {
        serializeAndAssertEquals2("iosAlert.json", Cf.list(GlobalSubscriptionChannel.IOS.value()), Option.of("some_url"));
    }

    @Test
    public void genIosAlertBodyWOLink() {
        serializeAndAssertEquals2("iosAlertWOLink.json", Cf.list(), Option.empty());
    }

    private void serializeAndAssertEquals2(String filename, ListF<String> tags, Option<String> someUrl) {
        JsonAssert.equals(getClass(), filename,
                new XivaEvent(XivaEventRecipient.passport(1L), "test", tags)
                        .withBody(consIosAlertPushBody(someUrl))
                        .serializeBody()
        );
    }

    @NotNull
    private IosAlertPushBody consIosAlertPushBody(Option<String> linkO) {
        return new IosAlertPushBody(
                new NotificationPushInfo(
                        typeManager.resolveRecordType(DiskNotifications.PROMO_IOS).consMainTemplate(),
                        NotificationActor.YA_DISK,
                        Instant.now()
                ),
                Tuple2.tuple("test_push_title", "test_push_body"),
                NotificationEvents.MOBILE_V1,
                linkO
        );
    }
}
