package ru.yandex.chemodan.app.notifier.push.body;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.notifier.metadata.NotifierLanguage;

/**
 * @author akirakozov
 */
public class LanguageMap {
    private final MapF<NotifierLanguage, String> map;

    public LanguageMap(MapF<NotifierLanguage, String> map) {
        this.map = map;
    }

    public MapF<String, String> toSimpleMap() {
        MapF<String, String> result = Cf.hashMap();
        for (NotifierLanguage lang : map.keySet()) {
            result.put(lang.value(), map.getTs(lang));
        }
        return result;
    }
}
