package ru.yandex.chemodan.app.notifier.push.body;

import java.util.Map;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.chemodan.app.notifier.notification.NotificationTemplate;
import ru.yandex.chemodan.app.notifier.push.NotificationEvents;
import ru.yandex.chemodan.xiva.DiskLikeXivaPushBody;
import ru.yandex.chemodan.xiva.XivaPushBody;
import ru.yandex.chemodan.xiva.XivaPushBodyRepack;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.MarshallerContext;

/**
 * @author akirakozov
 */
@Bendable
@BenderBindAllFields
public class NotificationDesktopPushBody extends DiskLikeXivaPushBody implements XivaPushBody, XivaBodyWithTitleAndText {
    private final Parameters parameters;

    public NotificationDesktopPushBody(
            NotificationTemplate template,
            String actor, String link, String ctime,
            LanguageMap titles, LanguageMap texts,
            Option<String> preview, Option<String> previewFilePath, Option<String> previewResourceId)
    {
        super(NotificationEvents.WEB_DESKTOP_V1);
        this.parameters = new Parameters(template, actor, link, ctime, titles, texts, preview, previewFilePath, previewResourceId);
    }

    @Override
    public Tuple2<String, String> getTitleAndText() {
        String title = Cf.x(parameters.titles).getOrElse("ru", Cf.x(parameters.titles).entries().first()._2);
        String text = Cf.x(parameters.texts).getOrElse("ru", Cf.x(parameters.texts).entries().first()._2);

        return Tuple2.tuple(title, text);
    }

    @Override
    public void writePushBodyAsJson(BenderJsonWriter writer, MarshallerContext context) {
        mapper.serializeJsonAsSubclass(new Wrapper(this), writer, context);
    }

    @Override
    public XivaPushBodyRepack getRepack() {
        return new XivaPushBodyRepack()
                .includeSpecialAndAllPayloadFieldsToAllServices();
    }

    @BenderBindAllFields
    private static class Parameters {
        private final String actor;
        private final String link;
        private final String type;
        @BenderPart(name = "group_type", strictName = true)
        private final String groupType;
        private final String template;
        private final String icon;
        private final String ctime;
        private final Map<String, String> titles;
        private final Map<String, String> texts;

        public final Option<String> preview;
        @BenderPart(name = "preview_file_path", strictName = true)
        public final Option<String> previewFilePath;
        @BenderPart(name = "preview_resource_id", strictName = true)
        public final Option<String> previewResourceId;

        private Parameters(
                NotificationTemplate template,
                String actor, String link, String ctime,
                LanguageMap titles, LanguageMap texts,
                Option<String> preview, Option<String> previewFilePath, Option<String> previewResourceId)
        {
            this.actor = actor;
            this.link = link;
            this.ctime = ctime;
            this.type = template.getType();
            this.groupType = template.getGroup();
            this.template = template.getName();
            this.icon = template.getIcon();
            this.titles = titles.toSimpleMap();
            this.texts = texts.toSimpleMap();
            this.preview = preview;
            this.previewFilePath = previewFilePath;
            this.previewResourceId = previewResourceId;
        }
    }
}

