package ru.yandex.chemodan.app.notifier.push.body;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.chemodan.app.notifier.notification.NotificationTemplate;
import ru.yandex.chemodan.app.notifier.settings.GlobalSubscriptionChannelGroup;
import ru.yandex.chemodan.util.AppVersionRange;
import ru.yandex.chemodan.xiva.DiskLikeXivaPushBody;
import ru.yandex.chemodan.xiva.XivaPushBody;
import ru.yandex.chemodan.xiva.XivaPushBodyRepack;
import ru.yandex.chemodan.xiva.XivaPushService;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.serialize.BenderJsonSerializer;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.MarshallerContext;

/**
 * @author akirakozov
 */
@Bendable
public class NotificationMobilePushBody extends DiskLikeXivaPushBody implements XivaPushBody, XivaBodyWithTitleAndText {
    private static final BenderJsonSerializer<NotificationMobilePushBody.Parameters> serializer =
            Bender.jsonSerializer(NotificationMobilePushBody.Parameters.class);

    private final Parameters parameters;
    private final MapF<XivaPushService, AppVersionRange> serviceSpecificParams;
    private final boolean bright;

    public NotificationMobilePushBody(
            GlobalSubscriptionChannelGroup channelGroup,
            PassportUid uid,
            NotificationTemplate template,
            Option<String> link,
            String title,
            String text,
            String preview,
            Option<String> actionData,
            MapF<XivaPushService, AppVersionRange> serviceSpecificParams) {
        super(channelGroup.eventType);
        this.serviceSpecificParams = serviceSpecificParams;
        this.parameters = new Parameters(channelGroup.eventType, uid, template, link, title, text, preview, actionData);
        this.bright = channelGroup == GlobalSubscriptionChannelGroup.MOBILE_V2_BRIGHT;
    }

    public MapF<XivaPushService, AppVersionRange> getServiceSpecificParams() {
        return serviceSpecificParams;
    }

    @Override
    public Tuple2<String, String> getTitleAndText() {
        return Tuple2.tuple(parameters.title, parameters.text);
    }

    @Override
    public void writePushBodyAsJson(BenderJsonWriter writer, MarshallerContext context) {
        serializer.serializeJson(parameters, writer, context);
    }

    @Override
    public String toString() {
        return new String(serializer.serializeJson(parameters));
    }

    @Override
    public XivaPushBodyRepack getRepack() {
        XivaPushBodyRepack repack = new XivaPushBodyRepack()
                .addCustomFields(XivaPushSpecificParamsCreator.toSpecificParams(serviceSpecificParams))
                .includeTransitIdAndAllPayloadFieldsToAllServices();

        return !bright
                ? repack.withApnsSilent()
                : repack.withServiceRepackCopiedFromOther(XivaPushService.APNS, this::addAlert);
    }

    private void addAlert(XivaPushBodyRepack.ServiceRepack serviceRepack) {
        serviceRepack.addStandardField("aps",
                Cf.map(
                        "mutable-content", 1,
                        "alert", Cf.map("title", parameters.title, "body", parameters.text)
                )
        );
    }

    @BenderBindAllFields
    private static class Parameters {
        private final String uid;
        @BenderPart(name = "t")
        private final String tag;
        @BenderPart(name = "group_type", strictName = true)
        private final String groupType;
        @BenderPart(name = "action_type", strictName = true)
        private final String actionType;
        private final String template;
        private final String title;
        private final String text;
        private final Option<String> link;
        private final String preview;
        @BenderPart(name = "action_data", strictName = true)
        private final Option<String> actionData;

        private Parameters(
                String tag,
                PassportUid uid,
                NotificationTemplate template,
                Option<String> link,
                String title,
                String text,
                String preview,
                Option<String> actionData) {
            this.uid = uid.toString();
            this.tag = tag;
            this.link = link;
            this.actionType = template.getType();
            this.groupType = template.getGroup();
            this.template = template.getName();
            this.title = title;
            this.text = text;
            this.preview = preview;
            this.actionData = actionData;
        }
    }
}

