package ru.yandex.chemodan.app.notifier.push.body;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.notifier.notification.NotificationTemplate;
import ru.yandex.chemodan.app.notifier.notification.disk.DiskNotifications;
import ru.yandex.chemodan.app.notifier.push.NotificationEvents;
import ru.yandex.chemodan.util.AppVersionRange;
import ru.yandex.chemodan.xiva.XivaPushService;
import ru.yandex.commune.dynproperties.DynamicProperty;

/**
 * https://wiki.yandex-team.ru/disk/notifier/mobilev2/
 *
 * @author akirakozov
 */
public class XivaPushSpecificParamsCreator {

    private static final DynamicProperty<String> photoRemindCompRangeAppVersionGcm =
        new DynamicProperty<>("notifier-photo-remind-gcm-comp-app-ver", "3.15-");

    private static final DynamicProperty<String> photoRemindCompRangeAppVersionApns =
        new DynamicProperty<>("notifier-photo-remind-apns-comp-app-ver", "2.38-100.00");

    private static final DynamicProperty<String> photoNYCompRangeVersionGcm =
        new DynamicProperty<>("notifier-photo-selection-ny-gcm-comp-app-ver", "3.73-3.99");

    private static final DynamicProperty<String> photoNYCompRangeVersionApns =
        new DynamicProperty<>("notifier-photo-selection-ny-apns-comp-app-ver", "2.62-100.00");

    private static final DynamicProperty<String> photoSelectionRangeVersionGcm =
        new DynamicProperty<>("notifier-photo-selection-gcm-comp-app-ver", "4.19-");

    private static final DynamicProperty<String> photoSelectionCompRangeVersionApns =
        new DynamicProperty<>("notifier-photo-selection-apns-comp-app-ver", "2.54-100.00");

    public static final String COMP_VERSION_FIELD = "comp_version";

    // TODO: temporary fast hack, compatible versions should be stored in NotificationType record
    public static MapF<XivaPushService, AppVersionRange> createVersionCompatibilityParams(
            NotificationTemplate template, String notificationEvent)
    {
        if (!notificationEvent.equals(NotificationEvents.MOBILE_V2)) {
            return Cf.map();
        }

        if (template.getTypeName().equals(DiskNotifications.PHOTO_REMINDER)) {
            return Cf.map(XivaPushService.GCM, parseAppVersionsInterval(photoRemindCompRangeAppVersionGcm.get()),
                XivaPushService.APNS, parseAppVersionsInterval(photoRemindCompRangeAppVersionApns.get()));
        } else if (template.getTypeName().equals(DiskNotifications.PHOTO_SELECTION_NY_2018)) {
            return Cf.map(XivaPushService.GCM, parseAppVersionsInterval(photoNYCompRangeVersionGcm.get()),
                XivaPushService.APNS, parseAppVersionsInterval(photoNYCompRangeVersionApns.get()));
        } else if (template.getTypeName().getType().startsWith("photo_selection")) {
            return Cf.map(XivaPushService.GCM, parseAppVersionsInterval(photoSelectionRangeVersionGcm.get()),
                XivaPushService.APNS, parseAppVersionsInterval(photoSelectionCompRangeVersionApns.get()));
        }
        return Cf.map();
    }

    public static AppVersionRange parseAppVersionsInterval(String interval) {
        return AppVersionRange.fromIntervalString(interval);
    }

    public static MapF<XivaPushService, MapF<String, Object>> toSpecificParams(MapF<XivaPushService, AppVersionRange> appVersionParameters) {
        return appVersionParameters.mapValues(appVersionRange -> Cf.map(COMP_VERSION_FIELD, appVersionRange.asXivaParameterString()));
    }
}
