package ru.yandex.chemodan.app.notifier.push.body;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.util.AppVersion;
import ru.yandex.chemodan.util.AppVersionRange;
import ru.yandex.chemodan.xiva.XivaPushService;
import ru.yandex.misc.test.Assert;

/**
 * @author tolmalev
 */
public class XivaPushSpecificParamsCreatorTest {
    @Test
    public void parseCompVersionInterval() {
        AppVersionRange range = XivaPushSpecificParamsCreator.parseAppVersionsInterval("2.62-100.0");
        Assert.assertTrue(range.isInRangeBothInclusive(new AppVersion("2.63")));
        Assert.assertTrue(range.isInRangeBothInclusive(new AppVersion("3.0")));
        Assert.assertFalse(range.isInRangeBothInclusive(new AppVersion("2.61")));
        Assert.assertFalse(range.isInRangeBothInclusive(new AppVersion("100.61")));
    }

    @Test
    public void parseFromVersionInterval() {
        AppVersionRange range = XivaPushSpecificParamsCreator.parseAppVersionsInterval("2.62-");
        Assert.assertTrue(range.isInRangeBothInclusive(new AppVersion("2.63")));
        Assert.assertTrue(range.isInRangeBothInclusive(new AppVersion("3.0")));
        Assert.assertFalse(range.isInRangeBothInclusive(new AppVersion("2.61")));
    }

    @Test
    public void parseToVersionInterval() {
        AppVersionRange range = XivaPushSpecificParamsCreator.parseAppVersionsInterval("-2.72");
        Assert.assertTrue(range.isInRangeBothInclusive(new AppVersion("2.63")));
        Assert.assertFalse(range.isInRangeBothInclusive(new AppVersion("3.0")));
        Assert.assertTrue(range.isInRangeBothInclusive(new AppVersion("2.61")));
    }

    @Test
    public void toCustomProperties() {
        MapF<XivaPushService, AppVersionRange> ranges = Cf.map(XivaPushService.GCM, XivaPushSpecificParamsCreator.parseAppVersionsInterval("4.19-"),
            XivaPushService.APNS, XivaPushSpecificParamsCreator.parseAppVersionsInterval("2.54-100.0"));
        MapF<XivaPushService, MapF<String, Object>> result = XivaPushSpecificParamsCreator.toSpecificParams(ranges);
        Option<MapF<String, Object>> gcmValues = result.getO(XivaPushService.GCM);
        Assert.assertTrue(gcmValues.isPresent());
        Option<MapF<String, Object>> apnsValues = result.getO(XivaPushService.APNS);
        Assert.assertTrue(apnsValues.isPresent());
        Assert.assertEquals("419-", gcmValues.get().getTs(XivaPushSpecificParamsCreator.COMP_VERSION_FIELD));
        Assert.assertEquals("254-10000", apnsValues.get().getTs(XivaPushSpecificParamsCreator.COMP_VERSION_FIELD));
    }
}
