package ru.yandex.chemodan.app.notifier.push.filter;

import lombok.Value;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataFields;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.parse.BenderJsonParser;
import ru.yandex.misc.bender.parse.BenderJsonParserImpl;
import ru.yandex.misc.reflection.ClassX;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Value
public class DevicePushFilterConfig {
    public static final String FILTER_FIELD = "filter";

    public static final String ENABLED_FIELD = "enabled";

    public static DevicePushFilterConfig ALWAYS_ENABLED_CONFIG =
            new DevicePushFilterConfig(Cf.list(Matcher.DEFAULT_ENABLED));

    ListF<Matcher> matchers;

    public DevicePushFilterConfig(ListF<Matcher> matchers) {
        this.matchers = moveDefaultToBottom(matchers);
    }

    public static DevicePushFilterConfig fromDataApiRecords(ListF<DataRecord> records) {
        return new DevicePushFilterConfig(records.map(Matcher::fromDataApiRecord));
    }

    private static ListF<Matcher> moveDefaultToBottom(ListF<Matcher> matchers) {
        Tuple2<ListF<Matcher>, ListF<Matcher>> specificAndDefault = matchers.partition(Matcher::isDefault);
        return specificAndDefault.get2()
                .plus(specificAndDefault.get1());
    }

    boolean isEnabled(String group, String action) {
        return matchers.find(matcher -> matcher.matches(group, action))
                .map(Matcher::isEnabled)
                .getOrElse(true);
    }

    @Value
    static class Matcher {
        private static final String DEFAULT_MATCHER_ID = "other";

        private static Matcher DEFAULT_ENABLED = new Matcher(DEFAULT_MATCHER_ID, Cf.list(), true);

        String id;

        ListF<GroupAndActionPattern> patterns;

        boolean enabled;

        static Matcher fromDataApiRecord(DataRecord record) {
            DataFields data = record.data();
            return new Matcher(
                    record.id().recordId(),
                    GroupAndActionPattern.parseJsonList(data.get(FILTER_FIELD).stringValue()),
                    data.get(ENABLED_FIELD)
                            .booleanValue()
            );
        }

        boolean matches(String group, String action) {
            return isDefault() || patterns.exists(matcher -> matcher.matches(group, action));
        }

        boolean isDefault() {
            return id.equals(DEFAULT_MATCHER_ID);
        }
    }

    @Value
    @BenderBindAllFields
    static class GroupAndActionPattern {
        private static final BenderJsonParser<GroupAndActionPattern> parser =
                BenderJsonParserImpl.cons(
                        ClassX.wrap(GroupAndActionPattern.class),
                        BenderConfiguration.defaultConfiguration()
                );

        private static final String WILDCARD = "*";

        @BenderPart(name = "group")
        String groupPattern;

        @BenderPart(name = "action")
        String actionPattern;

        static ListF<GroupAndActionPattern> parseJsonList(String json) {
            return parser.parseListJson(json);
        }

        boolean matches(String group, String action) {
            return matchesPattern(groupPattern, group) && matchesPattern(actionPattern, action);
        }

        private static boolean matchesPattern(String pattern, String value) {
            return pattern.equals(WILDCARD) || pattern.equals(value);
        }
    }
}
