package ru.yandex.chemodan.app.notifier.push.filter;

import lombok.Value;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Value
public class NotificationPushFilter {
    public static final NotificationPushFilter ALL_ENABLED = new NotificationPushFilter(true, Option.empty());

    public static final NotificationPushFilter ALL_DISABLED = new NotificationPushFilter(false, Option.empty());

    boolean enabled;

    Option<ListF<String>> includeSubscriptionIds;

    public static NotificationPushFilter includeSubscriptionIds(ListF<String> subscriptionIds) {
        return subscriptionIds.isNotEmpty()
                ? new NotificationPushFilter(true, Option.of(subscriptionIds))
                : ALL_DISABLED;
    }
}
