package ru.yandex.chemodan.app.notifier.rtx;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;

/**
 * @author tolmalev
 */
@Configuration
public class RtxClientContextConfiguration {
    @Bean
    public RtxClient rtxClient(@Value("${rtx.base.uri}") String baseUri) {
        return new RtxClient(rxtHttpClientConfigurator().configure(), baseUri);
    }

    @Bean
    @Rtx
    @OverridableValuePrefix("rxt")
    public HttpClientConfigurator rxtHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }

    @Qualifier
    @Retention(RetentionPolicy.RUNTIME)
    public @interface Rtx {
    }
}
