package ru.yandex.chemodan.app.notifier.rtx;

import org.apache.http.client.config.RequestConfig;
import org.springframework.context.annotation.Bean;
import org.springframework.test.context.ContextConfiguration;

import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.chemodan.util.test.HttpRecorderRule;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;

@ContextConfiguration
public class RtxMockConfiguration {

    @Bean
    @RtxClientContextConfiguration.Rtx
    public HttpClientConfigurator rxtHttpClientConfigurator(HttpRecorderRule rule) {
        return new HttpClientConfigurator() {
            @Override
            public ApacheHttpClientUtils.Builder createBuilder() {
                return super.createBuilder().withRequestConfig(RequestConfig.custom().setProxy(rule.getHost()).build()).withRequestRetry();
            }
        };
    }

}
