package ru.yandex.chemodan.app.notifier.settings;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;

/**
 * @author buberman
 */
public enum GlobalSubscriptionChannel implements StringEnum {
    WEB(GlobalSubscriptionChannelGroup.WEB_DESKTOP_V1),
    // Use IOS, ANDROID channels
    @Deprecated
    MOBILE(GlobalSubscriptionChannelGroup.MOBILE_V1),
    DESKTOP(GlobalSubscriptionChannelGroup.WEB_DESKTOP_V1),
    IOS(GlobalSubscriptionChannelGroup.MOBILE_V2),
    ANDROID(GlobalSubscriptionChannelGroup.MOBILE_V2),
    IOS_NON_SILENT(GlobalSubscriptionChannelGroup.IOS_NON_SILENT),
    IOS_BRIGHT(GlobalSubscriptionChannelGroup.MOBILE_V2_BRIGHT),
    // this is a temporary type for the transition phase, while frontend is still using channel-based collections
    // for global settings. after frontend is able to use just one "all" record, this is obsolete
    ALL(GlobalSubscriptionChannelGroup.ALL)
    ;

    private static final ListF<GlobalSubscriptionChannel> PRIVATE = Cf.list(ALL, IOS_BRIGHT, IOS_NON_SILENT);

    public static final SetF<GlobalSubscriptionChannel> PUBLIC =
            NotifierCollectionUtils.linkedSet(Cf.list(values()).filterNot(PRIVATE::containsTs));

    public final GlobalSubscriptionChannelGroup group;

    GlobalSubscriptionChannel(GlobalSubscriptionChannelGroup group) {
        this.group = group;
    }

    public static final StringEnumResolver<GlobalSubscriptionChannel> R =
            StringEnumResolver.r(GlobalSubscriptionChannel.class);

    @Override
    public String value() {
        return name().toLowerCase();
    }

    public GlobalSubscriptionChannelGroup group() {
        return group;
    }

    public boolean belongsTo(GlobalSubscriptionChannelGroup group) {
        return this.group.equals(group);
    }
}
