package ru.yandex.chemodan.app.notifier.settings;

import ru.yandex.chemodan.app.notifier.push.NotificationEvents;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public enum GlobalSubscriptionChannelGroup {
    WEB_DESKTOP_V1(NotificationEvents.WEB_DESKTOP_V1),
    MOBILE_V1(NotificationEvents.MOBILE_V1),
    MOBILE_V2(NotificationEvents.MOBILE_V2),
    MOBILE_V2_BRIGHT(NotificationEvents.MOBILE_V2, "notification_mobile_v2_bright"),
    IOS_NON_SILENT("ios-non-silent"),
    ALL("all");

    public final String eventType;

    public final String logEventType;

    GlobalSubscriptionChannelGroup(String eventType) {
        this(eventType, eventType);
    }

    GlobalSubscriptionChannelGroup(String eventType, String logEventType) {
        this.eventType = eventType;
        this.logEventType = logEventType;
    }
}
