package ru.yandex.chemodan.app.notifier.settings;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.test.context.ContextConfiguration;

import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;
import ru.yandex.chemodan.app.dataapi.retry.RetryClauses;
import ru.yandex.chemodan.app.notifier.dao.NotificationSettingsDao;
import ru.yandex.chemodan.app.notifier.dao.NotificationSettingsDaoImpl;
import ru.yandex.chemodan.app.notifier.dao.NotificationsGlobalSettingsDao;
import ru.yandex.chemodan.app.notifier.dao.NotificationsGlobalSettingsDaoImpl;
import ru.yandex.chemodan.app.notifier.notification.NotificationRecordTypeManager;
import ru.yandex.chemodan.util.retry.RetryProxy;

/**
 * @author akirakozov
 */
@ContextConfiguration
public class NotificationSettingsContextConfiguration {
    @Value("${notifier.datasource.retry.count}")
    private int retryCount;

    private <T> T retryProxy(T impl, Class<T> iface) {
        return RetryProxy.proxy(impl, iface, retryCount,
                RetryClauses.dataApiAccess,
                RetryProxy.pushToNdcInterceptor());
    }

    @Bean
    public NotificationSettingsDao notificationSettingsDao(
            DataApiManager dataApiManager,
            NotificationRecordTypeManager notificationRecordTypeManager)
    {
        NotificationSettingsDaoImpl impl =
                new NotificationSettingsDaoImpl(dataApiManager, notificationRecordTypeManager);
        return retryProxy(impl, NotificationSettingsDao.class);
    }

    @Bean
    public NotificationsGlobalSettingsDao notificationsGlobalSettingsDao(
            DataApiManager dataApiManager,
            NotificationRecordTypeManager notificationRecordTypeManager)
    {
        NotificationsGlobalSettingsDaoImpl impl =
                new NotificationsGlobalSettingsDaoImpl(dataApiManager, notificationRecordTypeManager);
        return retryProxy(impl, NotificationsGlobalSettingsDao.class);
    }

    @Bean
    public NotificationsSettingsManager notificationsSettingsManager(NotificationSettingsDao notificationSettingsDao) {
        return new NotificationsSettingsManager(notificationSettingsDao);
    }

    @Bean
    public NotificationsGlobalSettingsManager notificationsGlobalSettingsManager(
            NotificationsGlobalSettingsDao notificationsGlobalSettingsDao)
    {
        return new NotificationsGlobalSettingsManager(notificationsGlobalSettingsDao);
    }
}
