package ru.yandex.chemodan.app.notifier.settings;

import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.notifier.dao.NotificationsGlobalSettingsDao;
import ru.yandex.chemodan.app.notifier.notification.ServiceAndGroup;

/**
 * @author buberman
 */
public class NotificationsGlobalSettingsManager {
    private final NotificationsGlobalSettingsDao notificationsGlobalSettingsDao;

    public NotificationsGlobalSettingsManager(NotificationsGlobalSettingsDao notificationsGlobalSettingsDao) {
        this.notificationsGlobalSettingsDao = notificationsGlobalSettingsDao;
    }

    public boolean isUserSubscribed(DataApiUserId uid, GlobalSubscriptionChannel channel, ServiceAndGroup group) {
        return getUserSubscriptions(uid, channel, group.getService()).containsTs(group);
    }

    private SetF<ServiceAndGroup> getUserSubscriptions(
            DataApiUserId uid, GlobalSubscriptionChannel channel, String service)
    {
        return notificationsGlobalSettingsDao.getNotificationsSettings(uid, channel, service);
    }
}
