package ru.yandex.chemodan.app.notifier.settings;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.notifier.dao.NotificationSettingsDao;
import ru.yandex.chemodan.app.notifier.notification.ServiceAndGroup;

/**
 * @author buberman
 */
public class NotificationsSettingsManager {
    private final NotificationSettingsDao notificationSettingsDao;

    public NotificationsSettingsManager(NotificationSettingsDao notificationSettingsDao) {
        this.notificationSettingsDao = notificationSettingsDao;
    }

    public void disableResourceNotifications(DataApiUserId uid, String resource,
            SetF<ServiceAndGroup> groups)
    {
        notificationSettingsDao.disableResourceNotifications(uid, fixSubscriptionKey(resource), groups);
    }

    public void enableResourceNotifications(DataApiUserId uid, String resource,
            SetF<ServiceAndGroup> groups)
    {
        notificationSettingsDao.enableResourceNotifications(uid, fixSubscriptionKey(resource), groups);
    }

    public boolean isSubscribed(DataApiUserId uid, String resource, ServiceAndGroup group) {
        return notificationSettingsDao.isSubscribed(uid, fixSubscriptionKey(resource), group);
    }

    public CollectionF<SettingsRecord> getSubscribedResources(DataApiUserId uid, String service,
            Option<String> resource)
    {

        return notificationSettingsDao.getSubscribedResources(uid, service, resource.map(this::fixSubscriptionKey));
    }

    // TODO: temporary code for migration
    private String fixSubscriptionKey(String subscriptionKey) {
        // public-, private- are prefixes of new version
        return subscriptionKey.startsWith("public-") || subscriptionKey.startsWith("private-") ?
            subscriptionKey : "public-" + subscriptionKey;
    }
}
