package ru.yandex.chemodan.app.notifier.settings;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.SetF;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class NotifierCollectionUtils {
    @SafeVarargs
    public static <T> SetF<T> linkedSet(T... elements) {
        return linkedSet(Arrays.asList(elements));
    }

    public static <T> SetF<T> linkedSet(Collection<T> collection) {
        return Cf.wrap(new LinkedHashSet<>(collection));
    }
}
