package ru.yandex.chemodan.app.notifier.settings;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.support.RecordField;
import ru.yandex.chemodan.app.notifier.notification.NotificationGroup;
import ru.yandex.chemodan.app.notifier.notification.NotificationRecordTypeManager;
import ru.yandex.chemodan.app.notifier.notification.ServiceAndGroup;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author buberman
 */
public class SettingsRecord extends DefaultObject {
    public final String id;
    public final String service;
    public final SetF<ServiceAndGroup> notificationGroups;

    public SettingsRecord(String id, String service, SetF<ServiceAndGroup> notificationGroups) {
        this.id = id;
        this.service = service;
        this.notificationGroups = notificationGroups;
    }

    public static SettingsRecord fromDataRecord(DataRecord record, String service,
            NotificationRecordTypeManager typeManager)
    {
        SetF<ServiceAndGroup> types = Cf.hashSet();

        for (NotificationGroup group : typeManager.getNotificationGroups(service)) {
            RecordField<Boolean> field = RecordField.bool(group.name);
            if (field.getO(record).getOrElse(true)) {
                types.add(group.getFullName());
            }
        }

        return new SettingsRecord(record.getRecordId(), service, types);
    }

    public MapF<String, DataField> toData(NotificationRecordTypeManager typeManager) {
        MapF<String, DataField> fields = Cf.hashMap();

        for (NotificationGroup group : typeManager.getNotificationGroups(service)) {
            RecordField<Boolean> field = RecordField.bool(group.name);
            fields.put(field.toData(notificationGroups.containsTs(group.getFullName())));
        }

        return fields;
    }

    public SettingsRecord plusNotificationGroups(CollectionF<ServiceAndGroup> groups) {
        return new SettingsRecord(id, service, notificationGroups.plus(groups));
    }

    public SettingsRecord minusNotificationGroups(SetF<ServiceAndGroup> groups) {
        return new SettingsRecord(id, service, notificationGroups.minus(groups));
    }
}
