package ru.yandex.chemodan.app.notifier.settings;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.chemodan.app.notifier.notification.NotificationRecordTypeManager;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author buberman
 */
@ActionResultPojo
@BenderBindAllFields
public class SettingsRecordPojo {
    public final String groupKey;
    public final MapF<String, Boolean> subscriptions;

    private SettingsRecordPojo(String groupKey, MapF<String, Boolean> subscriptions) {
        this.groupKey = groupKey;
        this.subscriptions = subscriptions;
    }

    public static SettingsRecordPojo cons(
            SettingsRecord record, NotificationRecordTypeManager notificationRecordTypeManager, String service)
    {
        MapF<String, Boolean> subscriptions = notificationRecordTypeManager.getNotificationGroups(service)
                .toMap(group -> Tuple2.tuple(group.name, record.notificationGroups.containsTs(group.getFullName())));

        return new SettingsRecordPojo(record.id, subscriptions);
    }

    public static SettingsRecordPojo subscribedToAll(NotificationRecordTypeManager notificationRecordTypeManager,
            String groupKey, String service)
    {
        return new SettingsRecordPojo(groupKey,
                notificationRecordTypeManager.getNotificationGroups(service).toMap(
                        group -> Tuple2.tuple(group.name, true)
                ));
    }
}
