package ru.yandex.chemodan.app.notifier.tanker;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.notifier.metadata.NotifierLanguage;
import ru.yandex.inside.tanker.model.TankerKey;
import ru.yandex.inside.tanker.model.TankerResponse;
import ru.yandex.inside.tanker.model.TankerTranslation;

/**
 * @author buberman
 */
public class TankerManager {
    private final TankerRegistry registry;

    public TankerManager(TankerRegistry registry) {
        this.registry = registry;
    }

    public Option<TankerTranslation> getTranslation(NotifierLanguage lang, TankerMessageKey messageKey) {
        return getAllTranslations(messageKey).getO(lang.value());
    }

    public MapF<String, TankerTranslation> getAllTranslations(TankerMessageKey messageKey) {
        if (getKeyset(messageKey.keysetId).containsKeyTs(messageKey.key)) {
            return getKeyset(messageKey.keysetId).getTs(messageKey.key).translations;
        } else {
            return Cf.map();
        }
    }

    public void reloadCurrentTankerState() {
        registry.refreshCachedState();
    }

    protected TankerResponse getResponse() {
        return registry.getData();
    }

    private MapF<String, TankerKey> getKeyset(String keysetId) {
        return getResponse().keysets.getTs(keysetId).keys;
    }
}
