package ru.yandex.chemodan.app.notifier.tanker;

import org.apache.http.client.HttpClient;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.client.ZkManager;
import ru.yandex.commune.zk2.client.ZkManagerContextConfiguration;
import ru.yandex.inside.tanker.TankerClient;
import ru.yandex.misc.io.http.Timeout;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;

/**
 * @author buberman
 */
@Configuration
@Import({
        ZkManagerContextConfiguration.class
})
public class TankerManagerConfiguration {
    @Bean
    public TankerRegistry tankerRegistry(
            TankerClient tankerClient,
            @Qualifier("zkRoot") ZkPath zkRoot,
            ZkManager zkManager,
            @Value("${tanker.additional-params}") String additionalParams,
            @Value("${notifier.tanker.project-id}") String projectId)
    {
        TankerRegistry tankerRegistry = new TankerRegistry(zkRoot.child("notifier_tanker"),
                tankerClient, additionalParams, projectId);
        zkManager.addClient(tankerRegistry);
        return tankerRegistry;
    }

    @Bean
    public TankerManager tankerManager(TankerRegistry tankerRegistry) {
        return new TankerManager(tankerRegistry);
    }

    @Bean
    public TankerClient tankerClient(@Value("${tanker.host}") String tankerHostPort) {
        HttpClient httpClient = ApacheHttpClientUtils.trustAllMultiThreadedHttpsClient(
                Timeout.seconds(5), 5, 10, "Yandex Disk Notifier");
        return new TankerClient(httpClient, tankerHostPort);
    }
}
