package ru.yandex.chemodan.app.notifier.tanker;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.app.dataapi.test.TestConstants;
import ru.yandex.chemodan.util.ZkUtils;
import ru.yandex.chemodan.zk.configuration.ImportZkEmbeddedConfiguration;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.misc.env.EnvironmentType;

/**
 * Created by buberman on 16.11.16.
 */
@Configuration
@ImportZkEmbeddedConfiguration
public class TankerManagerTestConfiguration {

    @Bean
    public ZkPath zkRoot() {
        return ZkUtils.rootPath(TestConstants.DATAAPI, EnvironmentType.TESTS);
    }

    @Bean
    public TankerRegistry tankerRegistry() {
        return new TestTankerRegistry(null);
    }

    @Bean
    public TankerManager tankerManager(TankerRegistry tankerRegistry) {
        return new TankerManager(tankerRegistry);
    }
}
